% M-member n-dimensional CT-swarm
% The agents have point mass dynamics 
% Extremum seeking control is used to force the vehicle convege
% to the minimum of the position
% The algorithm uses the positions of all the other
% members to update its position 
% by Veysel Gazi

clear all; close all;clc;

global M xp0 yp0 xs ys dt;
global a b c;
global w wo;


% parameter of swarming
M = 3;   % # of swarm members
%n = 2; % # of dimensions of the state space
%nn = 2*n; % dimension of the agent dynamics
%nnn = 3;
c=sqrt(3)/2;
a =sqrt(3)*c/3;
%b = 2/5;

% parameter of trust region
regsize(1:3)=1*ones(1,3);
regnum=3;

% Potential function weight

w=1.5;
wo=1;

% Set a random IC
% x0 = 30*rand(nn, M);   
% Set a random initial positions and zero speed

%x0 = [0*rand(n, M)-0.5 -0.5*rand(n, 1); zeros(1, M+1)]; 

xt0= 0*rand(2, 1);
rand('seed',0)
x0 = [0.5*rand(2,M)-1  xt0 ; zeros(1, M+1)];  

% Ode solver
t0 = 0.0;
ts = 10;
dt = 0.25;

N=ts/dt;
Nx=0;          % counter of state
Nt=0;          % counter of time

for i=1:N
    S=sprintf('\nThis is Iteration %d',i); %Display the turn of loop
    disp(S);
    
    % trust region method
    
    % set up trust region
    for ind=1:M
        xp(ind)=x0(1,ind);
        yp(ind)=x0(2,ind);            
    end
    
    xt=x0(1,M+1);
    yt=x0(2,M+1);
    
    xtemp=linspace(-0.5*regsize(1)+xp(1),0.5*regsize(1)+xp(1),regnum);
    ytemp=linspace(-0.5*regsize(1)+yp(1),0.5*regsize(1)+yp(1),regnum);
    [X1,Y1]=meshgrid(xtemp,ytemp);
    
    xtemp=linspace(-0.5*regsize(2)+xp(2),0.5*regsize(2)+xp(2),regnum);
    ytemp=linspace(-0.5*regsize(2)+yp(2),0.5*regsize(2)+yp(2),regnum);
    [X2,Y2]=meshgrid(xtemp,ytemp);
    
    xtemp=linspace(-0.5*regsize(3)+xp(3),0.5*regsize(3)+xp(3),regnum);
    ytemp=linspace(-0.5*regsize(3)+yp(3),0.5*regsize(3)+yp(3),regnum);
    [X3,Y3]=meshgrid(xtemp,ytemp);
        
    %Measurement of potential function
    J1=potential(X1,Y1,xp(2),yp(2),xp(3),yp(3),xt,yt);
    J1c=potential(xp(1),yp(1),xp(2),yp(2),xp(3),yp(3),xt,yt);
    [J1_min,J1_row,J1_col] = min2d(J1);
    
    J2=potential(X2,Y2,xp(1),yp(1),xp(3),yp(3),xt,yt);
    J2c=potential(xp(2),yp(2),xp(1),yp(1),xp(3),yp(3),xt,yt);
    [J2_min,J2_row,J2_col] = min2d(J2);
    
    J3=potential(X3,Y3,xp(1),yp(1),xp(2),yp(2),xt,yt);
    J3c=potential(xp(3),yp(3),xp(1),yp(1),xp(2),yp(2),xt,yt);
    [J3_min,J3_row,J3_col] = min2d(J3);
    
    % Update as compass search
    if J1_min==J1c
        regsize(1)=regsize(1)/2;
    end
    
    if J2_min==J2c
        regsize(2)=regsize(2)/2;
    end
    
    if J3_min==J3c
        regsize(3)=regsize(3)/2;
    end
    
    regsize
    
    xs(1)=X1(J1_row,J1_col);
    ys(1)=Y1(J1_row,J1_col);
    
    xs(2)=X2(J2_row,J2_col);
    ys(2)=Y2(J2_row,J2_col);
    
    xs(3)=X3(J3_row,J3_col);
    ys(3)=Y3(J3_row,J3_col);
    
    tf=t0+dt;
    %tspan = [t0 tf];
    tspan = t0:(tf-t0)/100:tf;
    xp0=xp(1:3);
    yp0=yp(1:3);
    myoptions = odeset('OutputFcn','odeplot');
    [t, x] = ode23('extremumswarming_no_derivative', tspan, x0, myoptions);

    % update
    t0=tf;
    
    
    % final position of vehicle after one iteration regulation
    for ind=1:M,
        xf(ind, :) = x(size(x,1), 3*(ind-1)+1:3*ind-1);
    end;
    
    % the final measured potential
    J1m=potential(xf(1,1),xf(1,2),xp(2),yp(2),xp(3),yp(3),xt,yt);
    J2m=potential(xf(2,1),xf(2,2),xp(1),yp(1),xp(3),yp(3),xt,yt);
    J2m=potential(xf(3,1),xf(3,2),xp(1),yp(1),xp(2),yp(2),xt,yt);
    
    % record x and t
    xreal(Nx+1:Nx+length(x),:)=x;
    Nx=length(xreal)-1;
    treal(Nt+1:Nt+length(t))=t;
    Nt=length(treal)-1;
    
    % ratio
%     for ind=1:M
%         
%         % Update as trust region
%         r(ind)=(J1c-J1m)/(J1c-J1_min);
%         
%         if r(ind)<0.25
%            regsize(ind)=regsize(ind)/4;
%            % hk=abs(p(I)-lambda)/4;
%            if regsize(ind)<=1/50;
%               regsize(ind)=1/50;
%            end
%          elseif  r(ind)>0.75 & norm([xf(ind,1),xf(ind,2)]-[xp(ind),yp(ind)])==regsize(ind)
%            regsize(ind)=2*regsize(ind);        
%         else
%            regsize(ind)=regsize(ind);
%         end
%     end
    
    xt=x(size(x,1),3*M+1);
    yt=x(size(x,1),3*(M+1)-1);
    x0=[xf.' [xt;yt] ; zeros(1, M+1)]; 
end

x=xreal;
t=treal;

% Find final position of the vehicles
for i=1:M,
  xf(i, :) = x(size(x,1), 3*(i-1)+1:3*i-1);
end;

% Find the center of the members
for i=1:size(x,1),
  ctr(i, :) = zeros(1,2);
  for j=1:M,
    ctr(i, :) = ctr(i, :) +  x(i, 3*(j-1)+1:3*j-1);
  end;
end;
ctr = ctr/M;
ctr0 = ctr(1, :);
[r,l]=size(ctr);

% plot simulation results
   
figure(2);
%plot(x0(1,1:M), x0(2,1:M), 'bo'); hold on;
%plot(x0(1,M+1), x0(2,M+1), 'go');
plot(x(:, 1), x(:, 2), '-'); hold on;
plot(x(:, 4), x(:, 5), '-'); hold on;
plot(x(:, 7), x(:, 8), '-'); hold on
%for i=1:M,
%  plot(x(:, 3*(i-1)+1), x(:, 3*(i-1)+2), '-'); 
%end;
hold on;
plot(x(:, 3*M+1), x(:, 3*M+2), 'g--');
plot(x(r, 3*M+1), x(r, 3*M+2),'g*');
plot(ctr(:,1),ctr(:,2),'k.'); % black circle: center of the agents group
plot(xf(:,1), xf(:,2), 'ro'); 
for i=1:M,
  for j=i:M,
    plot([xf(i,1), xf(j,1)], [xf(i,2), xf(j,2)], 'r--');
  end;
end;
hold off;
title('The paths of the swarm members');
grid

figure(3);
plot(xf(:,1), xf(:,2), 'ro'); hold on;
plot(ctr(:,1), ctr(:,2), 'o');
% for h=1:size(x,1)
% for i=1:M,
%   for j=i:M,
%     plot([xf3(i,1), xf(j,1)], [xf(i,2), xf(j,2)], 'r--');
%     %plot([x(h,i), x(h,i)], [x(h,j+4), x(h,j+4)], 'r--');
%   end;
% end; 
% end;
for i=1:5:r,
     plot([x(i,1), x(i,3+1)], [x(i,2), x(i,3+2)], 'r--');
     plot([x(i,3+1), x(i,3*2+1)], [x(i,3+2), x(i,3*2+2)], 'r--');
     plot([x(i,3*2+1), x(i,1)], [x(i,3*2+2), x(i,2)], 'r--');
end;

hold off;
title('The swarm formation during the tracking process');
grid



% if 4 > 3 
% 
% for j=1:size(x,1),
%   for i=1:M,
%     z(i, :) = x(j, 3*(i-1)+1:3*i-2);
%   end;
% 
%   MM(j) = 0;
%   cm(j) = 0;
%   mm(j) = 1000000;
%   for i=1:M-1,
%     for k = i+1:M,
%       if (norm(z(i, :) - z(k, :)) > MM(j))
%         MM(j) = norm(z(i, :) - z(k, :));
%       end;
% 
%       if (norm(z(i, :) - z(k, :)) < mm(j))
%         mm(j) = norm(z(i, :) - z(k, :));
%       end;
%       
%       cm(j) = cm(j) + norm(z(i, :) - z(k, :));
%     end;
%   end;
% 
%   cMM(j) = 0;
%   ccm(j) = 0;
%   cmm(j) = 1000000;
%   for i=1:M,
%     if (norm(z(i, :) - ctr0) > cMM(j))
%       cMM(j) = norm(z(i, :) - ctr0);
%     end;
% 
%     if (norm(z(i, :) - ctr0) < cmm(j))
%       cmm(j) = norm(z(i, :) - ctr0);
%     end;
% 
%     ccm(j) = ccm(j) + norm(z(i, :) - ctr0);
%   end;
% 
% end;
% 
% cm = (2*cm)/(M*(M-1));
% ccm = ccm/M;
% 
% figure(4);
% %plot(t, cMM,'b--'); hold on;
% plot(t, ccm,'r');
% %plot(t, cmm,'g-.'); hold off;
% grid;
% %title('The distance to the center');
% title('The average distance to the center');
% xlabel('time');
% ylabel('distance');
% %legend('maximum', 'average', 'minimum');
% 
% figure(4);
% plot(t, MM,'b--'); hold on;
% plot(t, cm,'g-.');
% plot(t, mm,'r'); hold off;
% grid;
% title('The intermember distances');
% xlabel('time');
% ylabel('distance');
% legend('maximum', 'average', 'minimum');
% 
% end;

figure(4);
plot(ctr(:,1),ctr(:,2),'o'); 
title('The plot of the center movement');
xlabel('t');
ylabel('center');
grid
hold on
plot(ctr(end,1),ctr(end,2),'r<'); 

% plot the value of J
% %%% J1
% for i=1:r,
% Jt(i)=(norm([x(i,1), x(i,2)]-[x(i,nnn*M+1), x(i,nnn*M+2)]) - a^2)^2+...
%       (norm([x(i,nnn+1), x(i,nnn+2)]-[x(i,nnn*M+1), x(i,nnn*M+2)]) - a^2)^2+...
%       (norm([x(i,nnn*2+1), x(i,nnn*2+2)]-[x(i,nnn*M+1), x(i,nnn*M+2)])^2 - a^2)^2;
% Jf(i)=gr([x(i,1), x(i,2)]-[x(i,nnn+1), x(i,nnn+2)], c)+...
%       gr([x(i,nnn+1), x(i,nnn+2)]-[x(i,nnn*2+1), x(i,nnn*2+2)], c)+...
%       gr([x(i,1), x(i,2)]-[x(i,nnn*2+1), x(i,nnn*2+2)], c);
% h(i)=(Jt(i)+w*Jf(i))/2;
% end;

%%% J2
for i=1:r,
Jt(i)=(norm([x(i,1), x(i,2)]-[x(i,3*M+1), x(i,3*M+2)]) - a^2)^2+...
      (norm([x(i,3+1), x(i,3+2)]-[x(i,3*M+1), x(i,3*M+2)]) - a^2)^2+...
      (norm([x(i,3*2+1), x(i,3*2+2)]-[x(i,3*M+1), x(i,3*M+2)])^2 - a^2)^2;

Jf(i)=(norm([x(i,1), x(i,2)]-[x(i,3+1), x(i,3+2)])^2 - c^2)^2+...
      (norm([x(i,3+1), x(i,3+2)]-[x(i,3*2+1), x(i,3*2+2)])^2 - c^2)^2+...
      (norm([x(i,1), x(i,2)]-[x(i,3*2+1), x(i,3*2+2)])^2 - c^2)^2;
h(i)=(Jt(i)+w*Jf(i))/2;
end;

figure,
plot(t, h);
title('The value of potential function J');
grid;

figure,
plot(t, Jt);
title('The value of potential function Jt');
grid;


figure,
plot(t, Jf);
title('The value of potential function Jf');
grid;


% function grepulsion = gr(y, d)
% 
% b = 20; c = 0.2;
% a = b*exp(-d*d/c);
% grepulsion = a*(norm(y)^2 + b*c*exp(-(norm(y)^2)/c);